/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.tree.species;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.registry.TypedRegistry;
import com.ferreusveritas.dynamictrees.api.treedata.TreePart;
import com.ferreusveritas.dynamictrees.block.branch.BasicRootsBlock;
import com.ferreusveritas.dynamictrees.block.entity.SpeciesBlockEntity;
import com.ferreusveritas.dynamictrees.block.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.block.rooty.RootyBlock;
import com.ferreusveritas.dynamictrees.block.rooty.SoilHelper;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKit;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKitConfiguration;
import com.ferreusveritas.dynamictrees.growthlogic.context.PositionalSpeciesContext;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.tree.family.Family;
import com.ferreusveritas.dynamictrees.tree.family.MangroveFamily;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.ferreusveritas.dynamictrees.worldgen.GenerationContext;
import com.ferreusveritas.dynamictrees.worldgen.JoCode;
import com.ferreusveritas.dynamictrees.worldgen.JoCodeRegistry;
import com.mojang.datafixers.util.Function3;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class MangroveSpecies
extends Species {
    public static final TypedRegistry.EntryType<Species> TYPE = MangroveSpecies.createDefaultType((Function3<ResourceLocation, Family, LeavesProperties, Species>)((Function3)MangroveSpecies::new));
    protected GrowthLogicKitConfiguration rootLogicKit = GrowthLogicKitConfiguration.getDefault();
    private int minWorldGenHeightOffset = 2;
    private int maxWorldGenHeightOffset = 6;
    protected float rootSignalEnergy = 16.0f;
    protected float rootTapering = 0.3f;
    protected int rootGrowthMultiplier = 15;
    protected int updateSoilOnWaterRadius = 5;

    public void setMinWorldGenHeightOffset(int minWorldGenHeightOffset) {
        this.minWorldGenHeightOffset = minWorldGenHeightOffset;
    }

    public void setMaxWorldGenHeightOffset(int maxWorldGenHeightOffset) {
        this.maxWorldGenHeightOffset = maxWorldGenHeightOffset;
    }

    public void setRootGrowthMultiplier(int rootGrowthMultiplier) {
        this.rootGrowthMultiplier = rootGrowthMultiplier;
    }

    public void setUpdateSoilOnWaterRadius(int updateSoilOnWaterRadius) {
        this.updateSoilOnWaterRadius = updateSoilOnWaterRadius;
    }

    public MangroveSpecies(ResourceLocation name, Family family, LeavesProperties leavesProperties) {
        super(name, family, leavesProperties);
        if (!(family instanceof MangroveFamily)) {
            throw new RuntimeException("Family " + family.getRegistryName() + " for mangrove species " + this.getRegistryName() + " is not of type " + MangroveFamily.class);
        }
    }

    @Override
    public MangroveFamily getFamily() {
        return (MangroveFamily)this.family;
    }

    @Override
    public boolean placeRootyDirtBlock(LevelAccessor level, BlockPos rootPos, int fertility) {
        boolean worldGenOnWater;
        BlockState dirtState = level.m_8055_(rootPos);
        Block dirt = dirtState.m_60734_();
        boolean bl = worldGenOnWater = this.isWater(dirtState) && fertility == 0;
        if (!SoilHelper.isSoilRegistered(dirt) && !(dirt instanceof RootyBlock) || worldGenOnWater) {
            level.m_7731_(rootPos, this.getFamily().getDefaultSoil().getSoilState(dirtState, fertility, this.doesRequireTileEntity(level, rootPos)), 3);
            BlockEntity tileEntity = level.m_7702_(rootPos);
            if (tileEntity instanceof SpeciesBlockEntity) {
                SpeciesBlockEntity speciesTE = (SpeciesBlockEntity)tileEntity;
                speciesTE.setSpecies(this);
            }
            return true;
        }
        return super.placeRootyDirtBlock(level, rootPos, fertility);
    }

    private boolean replaceSoilBlock(BlockState soilState, Level level, BlockPos rootPos, int fertility) {
        RootyBlock rootyBlock;
        Block block = soilState.m_60734_();
        if (block instanceof RootyBlock && !(rootyBlock = (RootyBlock)block).getSoilProperties().equals(this.getFamily().getDefaultSoil())) {
            BlockEntity TE = level.m_7702_(rootPos);
            BlockState rootCollarState = this.getFamily().getDefaultSoil().getSoilState(rootyBlock.getPrimitiveSoilState(soilState), fertility, (Boolean)soilState.m_61143_((Property)RootyBlock.IS_VARIANT));
            this.getFamily().getDefaultSoil().getBlock().ifPresent(root -> root.updateRadius((LevelAccessor)level, rootCollarState, rootPos, 3, true));
            if (TE != null) {
                level.m_151523_(TE);
                if (TE instanceof SpeciesBlockEntity) {
                    SpeciesBlockEntity speciesTE = (SpeciesBlockEntity)TE;
                    speciesTE.setSpecies(this);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean postGrow(Level level, BlockPos rootPos, BlockPos treePos, int fertility, boolean natural) {
        int radius = TreeHelper.getRadius((BlockGetter)level, treePos);
        BlockState soilState = level.m_8055_(rootPos);
        if (radius >= 8 || this.isWater(soilState) && radius >= this.updateSoilOnWaterRadius) {
            this.replaceSoilBlock(soilState, level, rootPos, fertility);
        }
        return super.postGrow(level, rootPos, treePos, fertility, natural);
    }

    @Override
    public boolean soilDestroyAction(Level level, @Nonnull BlockPos rootPos, BlockState state, @Nonnull Player player) {
        if (state.m_61138_((Property)RootyBlock.FERTILITY)) {
            return this.replaceSoilBlock(state, level, rootPos, (Integer)state.m_61143_((Property)RootyBlock.FERTILITY));
        }
        return false;
    }

    @Override
    public float rotChance(LevelAccessor level, BlockPos pos, RandomSource rand, int radius) {
        BlockState branchState = level.m_8055_(pos);
        if (branchState.m_60734_() instanceof BasicRootsBlock) {
            if (radius == 0) {
                return 0.0f;
            }
            if (((Boolean)branchState.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
                return 0.0f;
            }
            return 0.2f + 1.0f / (8.0f + (float)radius * 4.0f);
        }
        return super.rotChance(level, pos, rand, radius);
    }

    @Override
    public boolean update(Level level, RootyBlock rootyDirt, BlockPos rootPos, int fertility, TreePart treeBase, BlockPos treePos, RandomSource random, boolean natural) {
        BlockPos rootCrownPos = rootPos.m_7495_();
        List<BlockPos> rootEnds = this.getEnds(level, rootCrownPos, TreeHelper.getTreePart(level.m_8055_(rootCrownPos)));
        this.handleRot((LevelAccessor)level, rootEnds, rootPos, rootCrownPos, fertility, SafeChunkBounds.ANY);
        return super.update(level, rootyDirt, rootPos, fertility, treeBase, treePos, random, natural);
    }

    @Override
    public boolean generate(GenerationContext context) {
        JoCode code;
        int yOffset = context.random().m_216332_(this.minWorldGenHeightOffset, this.maxWorldGenHeightOffset) - this.countWaterBlocksBelow(context.level(), (BlockPos)context.rootPos(), this.getAllowedWaterHeightForWorldgen());
        context.rootPos().m_122175_(Direction.UP, yOffset);
        if (super.generate(context) && !JoCodeRegistry.getCodes(this.getRegistryName(), true).isEmpty() && (code = JoCodeRegistry.getRandomCode(this.getRegistryName(), context.radius(), context.random(), true)) != null) {
            code.generate(context);
            return true;
        }
        return false;
    }

    public float getRootSignalEnergy() {
        return this.rootSignalEnergy;
    }

    public void setRootSignalEnergy(float rootSignalEnergy) {
        this.rootSignalEnergy = rootSignalEnergy;
    }

    public float getRootTapering() {
        return this.rootTapering;
    }

    public void setRootTapering(float rootTapering) {
        this.rootTapering = rootTapering;
    }

    @Override
    protected GrowSignal sendGrowthSignal(TreePart treeBase, Level level, BlockPos treePos, BlockPos rootPos, Direction defaultDir) {
        GrowSignal treeSignal = super.sendGrowthSignal(treeBase, level, treePos, rootPos, defaultDir);
        for (int i = 0; i < this.rootGrowthMultiplier; ++i) {
            BlockPos belowPos = rootPos.m_7495_();
            BlockState belowState = level.m_8055_(belowPos);
            if (TreeHelper.isBranch(belowState)) {
                GrowSignal rootGrowSignal = new GrowSignal(this, rootPos, this.getRootEnergy(level, rootPos), level.f_46441_, defaultDir.m_122424_());
                return TreeHelper.getTreePart(belowState).growSignal(level, belowPos, rootGrowSignal);
            }
            this.getFamily().getRoots().ifPresent(branch -> branch.setRadius((LevelAccessor)level, belowPos, this.family.getPrimaryThickness(), null));
        }
        return treeSignal;
    }

    public float getRootEnergy(Level level, BlockPos rootPos) {
        return this.rootLogicKit.getEnergy(new PositionalSpeciesContext(level, rootPos, this));
    }

    public Species setRootsGrowthLogicKit(GrowthLogicKit logicKit) {
        this.rootLogicKit = (GrowthLogicKitConfiguration)logicKit.getDefaultConfiguration();
        return this;
    }

    public Species setRootsGrowthLogicKit(GrowthLogicKitConfiguration logicKit) {
        this.rootLogicKit = logicKit;
        return this;
    }

    public GrowthLogicKitConfiguration getRootsGrowthLogicKit() {
        return this.rootLogicKit;
    }
}

